import java.io.*;

public class Main {
  private PrintWriter outp = null;
  public double pobierzLiczbe(StreamTokenizer strTok) throws IOException {
    while(strTok.nextToken() != StreamTokenizer.TT_NUMBER){
      outp.println("To nie jest poprawna liczba.");outp.flush();
      outp.print("Wprowadź poprawną liczbę: ");outp.flush();
    }
    return strTok.nval;
  }

  public void oblicz(double A, double B, double C) {
    outp.println ("Parametry równania:\n");outp.flush();
    outp.println ("A: " + A + " B: " + B + " C: " + C + "\n");outp.flush();

    if (A == 0){
      outp.println ("To nie jest równanie kwadratowe: A = 0!");outp.flush();
    }
    else{  
      double delta = B * B - 4 * A * C;

      if (delta < 0){
        outp.println ("Delta < 0.");outp.flush();
        outp.println ("To równanie nie ma rozwiązania w zbiorze liczb rzeczywistych.");outp.flush();
      }
      else if(delta == 0){
        double wynik = - B / (2 * A);
        outp.println ("Rozwiązanie: x = " + wynik);outp.flush();

      }
      else if(delta > 0){
        double wynik;
        wynik = (- B + Math.sqrt(delta)) / (2 * A);
        outp.print ("Rozwiązanie: x1 = " + wynik);outp.flush();
        wynik = (- B - Math.sqrt(delta)) / (2 * A);
        outp.println (", x2 = " + wynik);outp.flush();
      }
    }
  }
  public void start() {
    StreamTokenizer strTok = new StreamTokenizer(
      new BufferedReader(
        new InputStreamReader(System.in)
      )
    );

    double paramA = 0;
    double paramB = 0;
    double paramC = 0;

    try{
      outp.print("Podaj parametr A: ");outp.flush();
      paramA = pobierzLiczbe(strTok);
      outp.print("Podaj parametr B: ");outp.flush();
      paramB = pobierzLiczbe(strTok);
      outp.print("Podaj parametr C: ");outp.flush();
      paramC = pobierzLiczbe(strTok);
      outp.println("");outp.flush();
    }
    catch(IOException e){
      outp.println("Błąd podczas odczytu strumienia.");
      return;
    }
    oblicz(paramA, paramB, paramC);
  }
  public Main()
  {
    try{
      outp = new PrintWriter(
        new OutputStreamWriter(System.out, "Cp852"), true
      );
    }
    catch(UnsupportedEncodingException e){
      System.out.println("Nie można ustawić strony kodowej Cp852.");
      outp = new PrintWriter(new OutputStreamWriter(System.out), true);
    }
  }
  public static void main (String args[]) {
    Main main = new Main();
    main.start();
  }
}
